/******************************************************************************
 *
 * Copyright (c) 2013 TP-LINK Technologies CO.,LTD.
 * All rights reserved.
 *
 * FILE NAME  :   gpio_led.c
 * VERSION    :   1.0
 * DESCRIPTION:   APIs which control LED on/off/blinking.
 *
 * AUTHOR     :   Teng Fei <tengfei@tp-link.net>
 * CREATE DATE:   04/25/2013
 *
 * HISTORY    :
 * 01   04/25/2013  Teng Fei     Create.
 * 02   07/07/2016  zhou guofeng modify for plc
 *
 ******************************************************************************/
 /*
#1	INCLUDE FILES FOR MODULE
*/
#include "gpio_led.h"
#include "gpio_config.h"
#include "../autoconf.h"


#define tplink_reg_read(addr) 			RALINK_REG(addr)

#define tplink_reg_write(addr, value)	RALINK_REG(addr) = value

/* GPIO Pin DIR valid value */
#define TP_GPIO_DIR_OUT_VALUE			1
#define TP_GPIO_DIR_IN_VALUE			0



u32 tplink_gpio_set_value(int pos, int mask, int value, u32 in_value)
{
	u32 m = mask << pos;
	u32 v = value << pos;
	u32 out_value = in_value;

	out_value &= ~m; /* clear section */

	out_value |= v;

	return out_value;
}



u32 tplink_gpio_mode_addr(int pin)
{
#if defined (MT7628_ASIC_BOARD)
	if (pin >= 36 && pin <= 38)
		return RALINK_GPIOMODE1_REG;
	else if (pin > 39 && pin < 45)
		return RALINK_GPIOMODE2_REG;
	else
		return ~0x0;
	
#else
	return ~0x0;
#endif
}

int tplink_gpio_mode_reg_offset(int pin)
{	
#if defined (MT7628_ASIC_BOARD)
	if (pin == 36)
		return 16;
	else if (pin == 37)
		return 18;
	else if (pin == 38)
		return 14;
	else if (pin >= 39 && pin <= 43)
		return (43 - pin) * 2 + 2;
	else if (pin == 44)
		return 0;

	return -1;
#else
	return -1;
#endif
}

int tplink_gpio_mode_reg_mask(int pin)
{
#if defined (MT7628_ASIC_BOARD)
	if (pin >=36 && pin <= 38)
		return 0x1;
	else if (pin >= 39 && pin <= 44)
		return 0x3;

	return 0;
#else
	return 0;
#endif
}

int tplink_gpio_mode_reg_value(int pin)
{
#if defined (MT7628_ASIC_BOARD)
/*	if (pin >=36 && pin <= 38)
		return 1;
	else if (pin >= 39 && pin <= 44)
		return 1;
*/
	return 1;
#else
	return 0;
#endif
}



void tplink_gpio_mode_set(int pin)
{
	u32 gpioMode;
	u32 modeAddr;
	modeAddr = tplink_gpio_mode_addr(pin);

	if (modeAddr != ~0x0)
	{			
		gpioMode = tplink_reg_read(modeAddr);
		
		gpioMode = tplink_gpio_set_value(tplink_gpio_mode_reg_offset(pin)
			, tplink_gpio_mode_reg_mask(pin)
			, tplink_gpio_mode_reg_value(pin)
			, gpioMode);
		
		tplink_reg_write(modeAddr, gpioMode);
	}

	return ;	
}


u32 tplink_gpio_data_addr(int dataPin)
{
#if defined (TP_PRODUCT_WPA4220V3_MT7628)
	return RALINK_PIO_BASE + 0x20 + (dataPin / 32) * 4;
#endif
}



u32 tplink_gpio_dir_addr(int dirPin)
{
#if defined (TP_PRODUCT_WPA4220V3_MT7628)
	return RALINK_PIO_BASE + (dirPin / 32) * 4;
#endif
}


u32 tplink_gpio_set_bit(int pos, int bitvalue, u32 in_value)
{
	u32 mask = 1 << pos;
	u32 out_value = in_value;
	if (bitvalue)
		out_value |= mask;
	else
		out_value &= ~mask;

	return out_value;
}


int tplink_gpio_dir_reg_offset(int dirPin)
{	
#if defined (TP_PRODUCT_WPA4220V3_MT7628)
	return (dirPin % 32);
#endif
}


int tplink_gpio_data_reg_offset(int dataPin)
{	
#if defined (TP_PRODUCT_WPA4220V3_MT7628)
	return (dataPin % 32);
#endif
}



void tplink_gpio_datareg_set(int dataPin, int pinValue)
{	
	u32 gpioData;
	//if (dirAddr)
	{			
		gpioData = tplink_reg_read(tplink_gpio_data_addr(dataPin));
//		printf("GPIO#%d reg 0x%x[0]=0x%x ->", dataPin, tplink_gpio_data_addr(dataPin), gpioData);
		gpioData = tplink_gpio_set_bit(tplink_gpio_data_reg_offset(dataPin),
									   pinValue, gpioData);
//		printf("0x%x, offset %d\n", gpioData, tplink_gpio_data_reg_offset(dataPin));
		tplink_reg_write(tplink_gpio_data_addr(dataPin), gpioData);
	}
	
	return ;	
}




void tplink_gpio_dirreg_set(int dirPin, int pinValue)
{	
	u32 gpioDir;
	u32 dirAddr;
	dirAddr = tplink_gpio_dir_addr(dirPin);
	//if (dirAddr)
	{			
		gpioDir = tplink_reg_read(dirAddr);
		gpioDir = tplink_gpio_set_bit(tplink_gpio_dir_reg_offset(dirPin),
									   pinValue, gpioDir);
		tplink_reg_write(dirAddr, gpioDir);
	}
}



void tplink_init_gpio_reg()
{
#if defined (TP_PRODUCT_RE350_MT7621)
	/* set GPIO_DIR register */
	RALINK_REG(RALINK_PIO_BASE) |= (1 << 22);	// set GPIO#22 to output mode at GPIO_CTRL_0 Register
	RALINK_REG(RALINK_PIO_BASE) |= (1 << 23);	// set GPIO#23 to output mode at GPIO_CTRL_0 Register
	RALINK_REG(RALINK_PIO_BASE) |= (1 << 24);	// set GPIO#24 to output mode at GPIO_CTRL_0 Register
	RALINK_REG(RALINK_PIO_BASE) |= (1 << 25);	// set GPIO#25 to output mode at GPIO_CTRL_0 Register
	RALINK_REG(RALINK_PIO_BASE) |= (1 << 26);	// set GPIO#26 to output mode at GPIO_CTRL_0 Register
	RALINK_REG(RALINK_PIO_BASE) |= (1 << 28);	// set GPIO#28 to output mode at GPIO_CTRL_0 Register
	RALINK_REG(RALINK_PIO_BASE) |= (1 << 29);	// set GPIO#29 to output mode at GPIO_CTRL_0 Register
	
	RALINK_REG(RALINK_PIO_BASE) &= ~(1 << 18);	// set GPIO#18 to input mode at GPIO_CTRL_0 Register
	RALINK_REG(RALINK_PIO_BASE) &= ~(1 << 30);	// set GPIO#30 to input mode at GPIO_CTRL_0 Register
	RALINK_REG(RALINK_PIO_BASE) &= ~(1 << 31);	// set GPIO#31 to input mode at GPIO_CTRL_0 Register
	RALINK_REG(RALINK_PIO_BASE + 4) &= ~(1 << 0);	//set GPIO#32 to input mode at GPIO_CTRL_1 Register
	
	/* set GPIO_MODE register */
	RALINK_REG(RALINK_GPIOMODE_REG) |= (1 << 15);	// set RGMII2 to GPIO Mode
	RALINK_REG(RALINK_GPIOMODE_REG) |= (1 << 8);	// set WDT to GPIO Mode	
	
	printf("gpioMode Reg: 0x%x\n", RALINK_REG(RALINK_GPIOMODE_REG));
	/**/
#elif defined (TP_PRODUCT_RE305_MT7628)
	    /* set GPIO_DIR register (0xB0000604)*/
	RALINK_REG(RALINK_PIO_BASE + 4) |= (1 << 7);   // set GPIO#39 to output mode at GPIO_CTRL_1 Register
	RALINK_REG(RALINK_PIO_BASE + 4) |= (1 << 8);   // set GPIO#40 to output mode at GPIO_CTRL_1 Register
	RALINK_REG(RALINK_PIO_BASE + 4) |= (1 << 9);   // set GPIO#41 to output mode at GPIO_CTRL_1 Register
	RALINK_REG(RALINK_PIO_BASE + 4) |= (1 << 10);   // set GPIO#42 to output mode at GPIO_CTRL_1 Register
	RALINK_REG(RALINK_PIO_BASE + 4) |= (1 << 11);   // set GPIO#43 to output mode at GPIO_CTRL_1 Register

	RALINK_REG(RALINK_PIO_BASE + 4) &= ~(1 << 5);  // set GPIO#37 to input mode at GPIO_CTRL_1 Register
	RALINK_REG(RALINK_PIO_BASE + 4) &= ~(1 << 6);  // set GPIO#38 to input mode at GPIO_CTRL_1 Register

	/* set GPIO_MODE1(0xB0000060) and GPIO_MODE2(0xB0000064) register */
	RALINK_REG(RALINK_GPIOMODE1_REG) |= (1 << 14);   // set WDT to GPIO Mode (WPS button gpio38)
	RALINK_REG(RALINK_GPIOMODE1_REG) |= (1 << 18);    // set REFCLK to GPIO Mode (RESET button gpio37) 
	RALINK_REG(RALINK_GPIOMODE2_REG) |= (1 << 2);   // set P0_LED_AN to GPIO Mode (LED gpio42)
	RALINK_REG(RALINK_GPIOMODE2_REG) &= ~(1 << 3);   // bit3/2 : 01
	RALINK_REG(RALINK_GPIOMODE2_REG) |= (1 << 4);   // set P1_LED_AN to GPIO Mode (LED gpio43)
	RALINK_REG(RALINK_GPIOMODE2_REG) &= ~(1 << 5);   // bit5/4 : 01
	RALINK_REG(RALINK_GPIOMODE2_REG) |= (1 << 6);   // set P2_LED_AN to GPIO Mode (LED gpio41)
	RALINK_REG(RALINK_GPIOMODE2_REG) &= ~(1 << 7);   // bit7/6 : 01
	RALINK_REG(RALINK_GPIOMODE2_REG) |= (1 << 8);   // set P3_LED_AN to GPIO Mode (LED gpio40)
	RALINK_REG(RALINK_GPIOMODE2_REG) &= ~(1 << 9);   // bit9/8 : 01
	RALINK_REG(RALINK_GPIOMODE2_REG) |= (1 << 10);   // set P4_LED_AN to GPIO Mode (LED gpio39)
	RALINK_REG(RALINK_GPIOMODE2_REG) &= ~(1 << 11);   // bit11/10 : 01

	printf("gpioMode1 Reg: 0x%x\n", RALINK_REG(RALINK_GPIOMODE1_REG));
	printf("gpioMode2 Reg: 0x%x\n", RALINK_REG(RALINK_GPIOMODE2_REG));

#elif defined (TP_PRODUCT_820RE_MT7628)
	    /* set GPIO_DIR register (0xB0000604)*/
	RALINK_REG(RALINK_PIO_BASE + 4) |= (1 << 10);   // set GPIO#42 to output mode at GPIO_CTRL_1 Register
	RALINK_REG(RALINK_PIO_BASE + 4) |= (1 << 11);   // set GPIO#43 to output mode at GPIO_CTRL_1 Register

	RALINK_REG(RALINK_PIO_BASE + 4) &= ~(1 << 6);  // set GPIO#38 to input mode at GPIO_CTRL_1 Register

	/* set GPIO_MODE1(0xB0000060) and GPIO_MODE2(0xB0000064) register */
	RALINK_REG(RALINK_GPIOMODE1_REG) |= (1 << 14);   // set WDT to GPIO Mode (WPS button gpio38)
 
	RALINK_REG(RALINK_GPIOMODE2_REG) |= (1 << 2);   // set P0_LED_AN to GPIO Mode (LED gpio42)
	RALINK_REG(RALINK_GPIOMODE2_REG) &= ~(1 << 3);   // bit3/2 : 01
	RALINK_REG(RALINK_GPIOMODE2_REG) |= (1 << 4);   // set P1_LED_AN to GPIO Mode (LED gpio43)
	RALINK_REG(RALINK_GPIOMODE2_REG) &= ~(1 << 5);   // bit5/4 : 01

	printf("gpioMode1 Reg: 0x%x\n", RALINK_REG(RALINK_GPIOMODE1_REG));
	printf("gpioMode2 Reg: 0x%x\n", RALINK_REG(RALINK_GPIOMODE2_REG));

#elif defined (TP_PRODUCT_855RE_MT7628)
	    /* set GPIO_DIR register (0xB0000604)*/
	RALINK_REG(RALINK_PIO_BASE + 4) |= (1 << 7);   // set GPIO#39 to output mode at GPIO_CTRL_1 Register
	RALINK_REG(RALINK_PIO_BASE + 4) |= (1 << 10);   // set GPIO#42 to output mode at GPIO_CTRL_1 Register
	RALINK_REG(RALINK_PIO_BASE + 4) |= (1 << 11);   // set GPIO#43 to output mode at GPIO_CTRL_1 Register

	RALINK_REG(RALINK_PIO_BASE + 4) &= ~(1 << 5);  // set GPIO#37 to input mode at GPIO_CTRL_1 Register
	RALINK_REG(RALINK_PIO_BASE + 4) &= ~(1 << 6);  // set GPIO#38 to input mode at GPIO_CTRL_1 Register

	/* set GPIO_MODE1(0xB0000060) and GPIO_MODE2(0xB0000064) register */
	RALINK_REG(RALINK_GPIOMODE1_REG) |= (1 << 14);   // set WDT to GPIO Mode (WPS button gpio38)
	RALINK_REG(RALINK_GPIOMODE1_REG) |= (1 << 18);    // set REFCLK to GPIO Mode (RESET button gpio37) 
 
	RALINK_REG(RALINK_GPIOMODE2_REG) |= (1 << 2);   // set P0_LED_AN to GPIO Mode (LED gpio42)
	RALINK_REG(RALINK_GPIOMODE2_REG) &= ~(1 << 3);   // bit3/2 : 01
	RALINK_REG(RALINK_GPIOMODE2_REG) |= (1 << 4);   // set P1_LED_AN to GPIO Mode (LED gpio43)
	RALINK_REG(RALINK_GPIOMODE2_REG) &= ~(1 << 5);   // bit5/4 : 01
	RALINK_REG(RALINK_GPIOMODE2_REG) |= (1 << 10);   // set P4_LED_AN to GPIO Mode (LED gpio39)
	RALINK_REG(RALINK_GPIOMODE2_REG) &= ~(1 << 11);   // bit11/10 : 01

	printf("############gpioMode1 Reg: 0x%x\n", RALINK_REG(RALINK_GPIOMODE1_REG));
	printf("############gpioMode2 Reg: 0x%x\n", RALINK_REG(RALINK_GPIOMODE2_REG));

#elif defined (TP_PRODUCT_860RE_MT7628)
	/* set GPIO_DIR register (0xB0000604)*/
	RALINK_REG(RALINK_PIO_BASE + 4) |= (1 << 8);   // set GPIO#40 to output mode at GPIO_CTRL_1 Register
	RALINK_REG(RALINK_PIO_BASE + 4) |= (1 << 9);   // set GPIO#41 to output mode at GPIO_CTRL_1 Register
	RALINK_REG(RALINK_PIO_BASE + 4) |= (1 << 10);   // set GPIO#42 to output mode at GPIO_CTRL_1 Register
	RALINK_REG(RALINK_PIO_BASE + 4) |= (1 << 11);   // set GPIO#43 to output mode at GPIO_CTRL_1 Register

	RALINK_REG(RALINK_PIO_BASE + 4) &= ~(1 << 5);  // set GPIO#37 to input mode at GPIO_CTRL_1 Register
	RALINK_REG(RALINK_PIO_BASE + 4) &= ~(1 << 6);  // set GPIO#38 to input mode at GPIO_CTRL_1 Register
	RALINK_REG(RALINK_PIO_BASE + 4) &= ~(1 << 12);  // set GPIO#44 to input mode at GPIO_CTRL_1 Register

	/* set GPIO_MODE1(0xB0000060) and GPIO_MODE2(0xB0000064) register */
	RALINK_REG(RALINK_GPIOMODE1_REG) |= (1 << 14);   // set WDT to GPIO Mode (WPS button gpio38)
	RALINK_REG(RALINK_GPIOMODE1_REG) |= (1 << 18);    // set REFCLK to GPIO Mode (RESET button gpio37) 
	RALINK_REG(RALINK_GPIOMODE2_REG) |= (1 << 0);   // set P1_LED_AN to GPIO Mode (Power button gpio44)
	RALINK_REG(RALINK_GPIOMODE2_REG) &= ~(1 << 1);   // bit0/1 : 01

	RALINK_REG(RALINK_GPIOMODE2_REG) |= (1 << 8);   // set P3_LED_AN to GPIO Mode (LED gpio40)
	RALINK_REG(RALINK_GPIOMODE2_REG) &= ~(1 << 9);   // bit11/10 : 01
	RALINK_REG(RALINK_GPIOMODE2_REG) |= (1 << 6);   // set P2_LED_AN to GPIO Mode (LED gpio41)
	RALINK_REG(RALINK_GPIOMODE2_REG) &= ~(1 << 7);   // bit11/10 : 01
	RALINK_REG(RALINK_GPIOMODE2_REG) |= (1 << 4);   // set P1_LED_AN to GPIO Mode (LED gpio42)
	RALINK_REG(RALINK_GPIOMODE2_REG) &= ~(1 << 5);   // bit3/2 : 01
	RALINK_REG(RALINK_GPIOMODE2_REG) |= (1 << 2);   // set P0_LED_AN to GPIO Mode (LED gpio43)
	RALINK_REG(RALINK_GPIOMODE2_REG) &= ~(1 << 3);   // bit5/4 : 01

	printf("############gpioMode1 Reg: 0x%x\n", RALINK_REG(RALINK_GPIOMODE1_REG));
	printf("############gpioMode2 Reg: 0x%x\n", RALINK_REG(RALINK_GPIOMODE2_REG));

#elif defined (TP_PRODUCT_RE200_MT7620)
#elif defined (TP_PRODUCT_RE210_MT7620)
#if 0
#elif defined (TP_PRODUCT_WPA4220V3_MT7628)
	RALINK_REG(RALINK_PIO_BASE + 4) = dirreg;
	RALINK_REG(RALINK_GPIOMODE1_REG) = mode1reg;
	RALINK_REG(RALINK_GPIOMODE2_REG) = mode2reg;

	RALINK_REG(RALINK_PIO_BASE + 4) &= ~(1 << 6);  // set GPIO#38 to input mode at GPIO_CTRL_1 Register
	RALINK_REG(RALINK_PIO_BASE + 4) &= ~(1 << 7);  // set GPIO#39 to input mode at GPIO_CTRL_1 Register
	RALINK_REG(RALINK_PIO_BASE + 4) &= ~(1 << 8);  // set GPIO#40 to input mode at GPIO_CTRL_1 Register

	RALINK_REG(RALINK_PIO_BASE + 4) |= (1 << 5);   // set GPIO#37 to output mode at GPIO_CTRL_1 Register
	RALINK_REG(RALINK_PIO_BASE + 4) |= (1 << 9);   // set GPIO#41 to output mode at GPIO_CTRL_1 Register
	RALINK_REG(RALINK_PIO_BASE + 4) |= (1 << 10);   // set GPIO#42 to output mode at GPIO_CTRL_1 Register
	RALINK_REG(RALINK_PIO_BASE + 4) |= (1 << 11);   // set GPIO#43 to output mode at GPIO_CTRL_1 Register

	RALINK_REG(RALINK_GPIOMODE1_REG) |= (1 << 14);   // set WDT to GPIO Mode (WPS button gpio38)
	RALINK_REG(RALINK_GPIOMODE2_REG) |= (1 << 10);	// set P4_LED_AN to GPIO Mode (PAIR button gpio39)
	RALINK_REG(RALINK_GPIOMODE2_REG) &= ~(1 << 11); // bit11/10 : 01
	RALINK_REG(RALINK_GPIOMODE2_REG) |= (1 << 8);	// set P3_LED_AN to GPIO Mode (WIFI button gpio40)
	RALINK_REG(RALINK_GPIOMODE2_REG) &= ~(1 << 9);   // bit8/9 : 01

	RALINK_REG(RALINK_GPIOMODE2_REG) |= (1 << 4);   // set P1_LED_AN to GPIO Mode (LED control gpio42)
	RALINK_REG(RALINK_GPIOMODE2_REG) &= ~(1 << 5);   // bit3/2 : 01
	RALINK_REG(RALINK_GPIOMODE2_REG) |= (1 << 2);   // set P0_LED_AN to GPIO Mode (LED power gpio43)
	RALINK_REG(RALINK_GPIOMODE2_REG) &= ~(1 << 3);   // bit5/4 : 01
	RALINK_REG(RALINK_GPIOMODE2_REG) |= (1 << 6);   // set P2_LED_AN to GPIO Mode (LED gpio41)
	RALINK_REG(RALINK_GPIOMODE2_REG) &= ~(1 << 7);   // bit11/10 : 01
	RALINK_REG(RALINK_GPIOMODE1_REG) |= (1 << 18);	// set REFCLK to GPIO Mode (LED WIFI gpio37) 

	
	printf("############gpioDir Reg: 0x%x\n", RALINK_REG(RALINK_PIO_BASE + 4));
	printf("############gpioMode1 Reg: 0x%x\n", RALINK_REG(RALINK_GPIOMODE1_REG));
	printf("############gpioMode2 Reg: 0x%x\n\n", RALINK_REG(RALINK_GPIOMODE2_REG));
#endif
	
#else /* PLC PLATFORM */

/*	u32 dirreg = RALINK_REG(RALINK_PIO_BASE + 4);
	u32 mode1reg = RALINK_REG(RALINK_GPIOMODE1_REG);
	u32 mode2reg = RALINK_REG(RALINK_GPIOMODE2_REG);
	printf("############gpioDir Reg: 0x%x\n", RALINK_REG(RALINK_PIO_BASE + 4));
	printf("############gpioMode1 Reg: 0x%x\n", RALINK_REG(RALINK_GPIOMODE1_REG));
	printf("############gpioMode2 Reg: 0x%x\n\n", RALINK_REG(RALINK_GPIOMODE2_REG));
*/

#ifdef GPIO_LED_PORT_SYS
	tplink_gpio_dirreg_set(GPIO_LED_PORT_SYS, TP_GPIO_DIR_OUT_VALUE);
	tplink_gpio_mode_set(GPIO_LED_PORT_SYS);
#endif

#ifdef GPIO_LED_PORT_LED_CONTROL
	tplink_gpio_dirreg_set(GPIO_LED_PORT_LED_CONTROL, TP_GPIO_DIR_OUT_VALUE);
	tplink_gpio_mode_set(GPIO_LED_PORT_LED_CONTROL);
#endif

#ifdef GPIO_LED_PORT_ETHERNET
	tplink_gpio_dirreg_set(GPIO_LED_PORT_ETHERNET, TP_GPIO_DIR_OUT_VALUE);
	tplink_gpio_mode_set(GPIO_LED_PORT_ETHERNET);
#endif

#ifdef GPIO_LED_PORT_WIFI_2G_AP
	tplink_gpio_dirreg_set(GPIO_LED_PORT_WIFI_2G_AP, TP_GPIO_DIR_OUT_VALUE);
	tplink_gpio_mode_set(GPIO_LED_PORT_WIFI_2G_AP);
#endif

#ifdef GPIO_LED_PORT_WIFI_5G_AP
	tplink_gpio_dirreg_set(GPIO_LED_PORT_WIFI_5G_AP, TP_GPIO_DIR_OUT_VALUE);
	tplink_gpio_mode_set(GPIO_LED_PORT_WIFI_5G_AP);
#endif


#ifdef GPIO_BTN_PORT_RESET
	tplink_gpio_dirreg_set(GPIO_BTN_PORT_RESET, TP_GPIO_DIR_IN_VALUE);	
	tplink_gpio_mode_set(GPIO_BTN_PORT_RESET);
#endif


#ifdef GPIO_BTN_PORT_WIFI
	tplink_gpio_dirreg_set(GPIO_BTN_PORT_WIFI, TP_GPIO_DIR_IN_VALUE);	
	tplink_gpio_mode_set(GPIO_BTN_PORT_WIFI);
#endif

#ifdef GPIO_BTN_PORT_PAIR
	tplink_gpio_dirreg_set(GPIO_BTN_PORT_PAIR, TP_GPIO_DIR_IN_VALUE);	
	tplink_gpio_mode_set(GPIO_BTN_PORT_PAIR);
#endif

/*
	printf("############gpioDir Reg: 0x%x\n", RALINK_REG(RALINK_PIO_BASE + 4));
	printf("############gpioMode1 Reg: 0x%x\n", RALINK_REG(RALINK_GPIOMODE1_REG));
	printf("############gpioMode2 Reg: 0x%x\n\n", RALINK_REG(RALINK_GPIOMODE2_REG));
*/

#endif

}

void tplink_turn_on_led()
{
#if defined (TP_PRODUCT_RE350_MT7621)
	/* set GPIO_DATA register */
	RALINK_REG(RALINK_PIO_BASE + 0x20) &= ~(1 << 22);	// turn on GPIO#22 
	RALINK_REG(RALINK_PIO_BASE + 0x20) &= ~(1 << 23);	// turn on GPIO#23 
	RALINK_REG(RALINK_PIO_BASE + 0x20) &= ~(1 << 24);	// turn on GPIO#24 
	RALINK_REG(RALINK_PIO_BASE + 0x20) &= ~(1 << 25);	// turn off GPIO#25 (Rssi Red Led) 
	RALINK_REG(RALINK_PIO_BASE + 0x20) |= (1 << 26);	// turn on GPIO#26 (Rssi Blue Led)	
	RALINK_REG(RALINK_PIO_BASE + 0x20) &= ~(1 << 28);	// turn on GPIO#28 
	RALINK_REG(RALINK_PIO_BASE + 0x20) &= ~(1 << 29);	// turn on GPIO#29 	
#elif defined (TP_PRODUCT_RE305_MT7628)
	/* set GPIO_DATA register datareg(B0000624 bit11-7:10000)*/
	RALINK_REG(RALINK_PIO_BASE + 0x24) &= ~(1 << 7);	// turn on GPIO#39
	RALINK_REG(RALINK_PIO_BASE + 0x24) &= ~(1 << 8);	// turn on GPIO#40
	RALINK_REG(RALINK_PIO_BASE + 0x24) &= ~(1 << 9);	// turn on GPIO#41
	RALINK_REG(RALINK_PIO_BASE + 0x24) &= ~(1 << 10);	// turn on GPIO#42 (Rssi Blue Led)
	RALINK_REG(RALINK_PIO_BASE + 0x24) |= (1 << 11);	// turn off GPIO#43 (Rssi Red Led)

#elif defined (TP_PRODUCT_820RE_MT7628)
	/* set GPIO_DATA register datareg(B0000624 bit11-10:01)*/
	RALINK_REG(RALINK_PIO_BASE + 0x24) &= ~(1 << 11);	// turn on GPIO#43 (Rssi Blue Led)
	RALINK_REG(RALINK_PIO_BASE + 0x24) |= (1 << 10);	// turn off GPIO#42 (Rssi Red Led)

#elif defined (TP_PRODUCT_855RE_MT7628)
	/* set GPIO_DATA register datareg(B0000624 bit11-10:01)*/
	RALINK_REG(RALINK_PIO_BASE + 0x24) &= ~(1 << 7);	// turn on GPIO#39
	RALINK_REG(RALINK_PIO_BASE + 0x24) &= ~(1 << 11);	// turn on GPIO#43 (Rssi Blue Led)
	RALINK_REG(RALINK_PIO_BASE + 0x24) |= (1 << 10);	// turn off GPIO#42 (Rssi Red Led)

#elif defined (TP_PRODUCT_860RE_MT7628)
	/* set GPIO_DATA register datareg(B0000624 bit11-10:01)*/
	RALINK_REG(RALINK_PIO_BASE + 0x24) &= ~(1 << 8);   // turn on GPIO#40(power Led)
	RALINK_REG(RALINK_PIO_BASE + 0x24) &= ~(1 << 9);   // turn on GPIO#41(WPS Led)
	RALINK_REG(RALINK_PIO_BASE + 0x24) &= ~(1 << 10);	// turn on GPIO#42 (Rssi Blue Led)
	RALINK_REG(RALINK_PIO_BASE + 0x24) |= (1 << 11);   // turn off GPIO#43 (Rssi Red Led)

#elif defined (TP_PRODUCT_RE200_MT7620)
#elif defined (TP_PRODUCT_RE210_MT7620)

#if 0
#elif defined (TP_PRODUCT_WPA4220V3_MT7628)
	RALINK_REG(RALINK_PIO_BASE + 0x24) &= ~(1 << 11);   // turn on GPIO#43(power Led)
	RALINK_REG(RALINK_PIO_BASE + 0x24) &= ~(1 << 9);   // turn on GPIO#41(ETH Led)
	RALINK_REG(RALINK_PIO_BASE + 0x24) &= ~(1 << 5);	// turn on GPIO#37 (WLAN 2G)
#endif


#else /* PLC PLATFORM */

#ifdef GPIO_LED_PORT_LED_CONTROL
	tplink_gpio_datareg_set(GPIO_LED_PORT_LED_CONTROL, TP_GPIO_LED_ON);
#endif

#ifdef GPIO_LED_PORT_SYS
	tplink_gpio_datareg_set(GPIO_LED_PORT_SYS, TP_GPIO_LED_ON);
#endif

#ifdef GPIO_LED_PORT_ETHERNET
	tplink_gpio_datareg_set(GPIO_LED_PORT_ETHERNET, TP_GPIO_LED_ON);
#endif

#ifdef GPIO_LED_PORT_WIFI_2G_AP
	tplink_gpio_datareg_set(GPIO_LED_PORT_WIFI_2G_AP, TP_GPIO_LED_ON);
#endif 

#ifdef GPIO_LED_PORT_WIFI_5G_AP
	tplink_gpio_datareg_set(GPIO_LED_PORT_WIFI_5G_AP, TP_GPIO_LED_ON);
#endif

#endif /* PRODUCT DEFINE */
}

void tplink_turn_off_led()
{
#if defined (TP_PRODUCT_RE350_MT7621)
	/* set GPIO_DATA register */
	RALINK_REG(RALINK_PIO_BASE + 0x20) |= (1 << 22);	// turn off GPIO#22 
	RALINK_REG(RALINK_PIO_BASE + 0x20) |= (1 << 23);	// turn off GPIO#23 
	RALINK_REG(RALINK_PIO_BASE + 0x20) |= (1 << 24);	// turn off GPIO#24 
	//RALINK_REG(RALINK_PIO_BASE + 0x20) |= (1 << 25);	// turn off GPIO#25 (Rssi Red Led)
	RALINK_REG(RALINK_PIO_BASE + 0x20) &= ~(1 << 25);	// turn off GPIO#25 (Rssi Red Led)
	RALINK_REG(RALINK_PIO_BASE + 0x20) |= (1 << 26);	// turn off GPIO#26 (Rssi Blue Led)
	//RALINK_REG(RALINK_PIO_BASE + 0x20) &= ~(1 << 26);	// turn off GPIO#26 (Rssi Blue Led)
	RALINK_REG(RALINK_PIO_BASE + 0x20) |= (1 << 28);	// turn off GPIO#28 
	RALINK_REG(RALINK_PIO_BASE + 0x20) |= (1 << 29);	// turn off GPIO#29 		
#elif defined (TP_PRODUCT_RE305_MT7628)
	/* set GPIO_DATA register datareg(B0000624 bit11-7:11111)*/
	RALINK_REG(RALINK_PIO_BASE + 0x24) |= (1 << 7);   // turn off GPIO#39
	RALINK_REG(RALINK_PIO_BASE + 0x24) |= (1 << 8);   // turn off GPIO#40
	RALINK_REG(RALINK_PIO_BASE + 0x24) |= (1 << 9);   // turn off GPIO#41
	RALINK_REG(RALINK_PIO_BASE + 0x24) |= (1 << 10);   // turn off GPIO#42 (Rssi Blue Led)
	RALINK_REG(RALINK_PIO_BASE + 0x24) |= (1 << 11);	// turn off GPIO#43 (Rssi Red Led)

#elif defined (TP_PRODUCT_820RE_MT7628)
	/* set GPIO_DATA register datareg(B0000624 bit11-10:11)*/
	RALINK_REG(RALINK_PIO_BASE + 0x24) |= (1 << 10);   // turn off GPIO#42 (Rssi Blue Led)
	RALINK_REG(RALINK_PIO_BASE + 0x24) |= (1 << 11);	// turn off GPIO#43 (Rssi Red Led)

#elif defined (TP_PRODUCT_855RE_MT7628)
	/* set GPIO_DATA register datareg(B0000624 bit11-10:11)*/
	RALINK_REG(RALINK_PIO_BASE + 0x24) |= (1 << 7);   // turn off GPIO#39
	RALINK_REG(RALINK_PIO_BASE + 0x24) |= (1 << 10);   // turn off GPIO#42 (Rssi Blue Led)
	RALINK_REG(RALINK_PIO_BASE + 0x24) |= (1 << 11);	// turn off GPIO#43 (Rssi Red Led)

#elif defined (TP_PRODUCT_WA850REV4)
	RALINK_REG(RALINK_PIO_BASE + 0x20) |= (1 << 4);
	RALINK_REG(RALINK_PIO_BASE + 0x20) |= (1 << 5);
	RALINK_REG(RALINK_PIO_BASE + 0x20) |= (1 << 11);	

	RALINK_REG(RALINK_PIO_BASE + 0x24) |= (1 << 7);
	RALINK_REG(RALINK_PIO_BASE + 0x24) |= (1 << 9);
	RALINK_REG(RALINK_PIO_BASE + 0x24) |= (1 << 10);
	RALINK_REG(RALINK_PIO_BASE + 0x24) |= (1 << 11);
	RALINK_REG(RALINK_PIO_BASE + 0x24) |= (1 << 12);

#elif defined (TP_PRODUCT_860RE_MT7628)
	/* set GPIO_DATA register datareg(B0000624 bit 8 ~ 11)*/
	RALINK_REG(RALINK_PIO_BASE + 0x24) |= (1 << 8);   // turn off GPIO#40(power Led)
	RALINK_REG(RALINK_PIO_BASE + 0x24) |= (1 << 9);   // turn off GPIO#41(WPS Led)
	RALINK_REG(RALINK_PIO_BASE + 0x24) |= (1 << 10);   // turn off GPIO#42 (Rssi Red Led)
	RALINK_REG(RALINK_PIO_BASE + 0x24) |= (1 << 11);	// turn off GPIO#43 (Rssi Blue Led)

#elif defined (TP_PRODUCT_RE200_MT7620)
#elif defined (TP_PRODUCT_RE210_MT7620)

#if 0
#elif defined (TP_PRODUCT_WPA4220V3_MT7628)
	RALINK_REG(RALINK_PIO_BASE + 0x24) |= (1 << 11);   // turn off GPIO#43(power Led)
	RALINK_REG(RALINK_PIO_BASE + 0x24) |= (1 << 9);   // turn off GPIO#41(ETH Led)
	RALINK_REG(RALINK_PIO_BASE + 0x24) |= (1 << 5);	// turn off GPIO#37 (WLAN 2G)

	RALINK_REG(RALINK_PIO_BASE + 0x24) |= (1 << 10); // turn on GPIO#42 (led control)
#endif


#else /* PLC PLATFORM */

#ifdef GPIO_LED_PORT_LED_CONTROL
	tplink_gpio_datareg_set(GPIO_LED_PORT_LED_CONTROL, TP_GPIO_LED_ON);
#endif


#ifdef GPIO_LED_PORT_SYS
	tplink_gpio_datareg_set(GPIO_LED_PORT_SYS, TP_GPIO_LED_OFF);
#endif

#ifdef GPIO_LED_PORT_ETHERNET
	tplink_gpio_datareg_set(GPIO_LED_PORT_ETHERNET, TP_GPIO_LED_OFF);
#endif

#ifdef GPIO_LED_PORT_WIFI_2G_AP
	tplink_gpio_datareg_set(GPIO_LED_PORT_WIFI_2G_AP, TP_GPIO_LED_OFF);
#endif 

#ifdef GPIO_LED_PORT_WIFI_5G_AP
	tplink_gpio_datareg_set(GPIO_LED_PORT_WIFI_5G_AP, TP_GPIO_LED_OFF);
#endif


#endif

}




void tplink_led_blink()
{
	tplink_turn_on_led();
	udelay (1000 * GPIO_POWER_UP_BLINK_TIME_INTVAL);
	tplink_turn_off_led();
	udelay (1000 * GPIO_POWER_UP_BLINK_TIME_INTVAL);
}

#ifdef CFG_DOUBLE_BOOT_FACTORY
void fwrecovery_gpio_init()
{
    ;//blinkLedInit();
}

int fwrecovery_led_on()
{
    tplink_turn_on_led();
    return 1;
}

int fwrecovery_led_off()
{
	tplink_turn_off_led();
    return 0;
}
#endif

